/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.IOException;

public class PatchFile
extends File {
    private static final String TRACE_MASKT = "XMCLFILT";
    private static final String TRACE_MASKF = "XMCLFILF";
    private static final String TRACE_MASKD = "XMCLFILD";
    private static final String PATCH_UTIL_SCRIPT_NAME = "actmUtil.pl";
    private static final int UTIL_CMD_EXISTS = 1;
    private static final int UTIL_CMD_MKDIRS = 2;
    private static final int UTIL_CMD_DELETE = 3;
    private static final int UTIL_CMD_ISDIR = 4;
    private static final String[] SAFE_TREES = new String[]{"/console/"};
    private boolean doViaJava = this.isPathSafe();

    public PatchFile(String pathname) {
        super(pathname);
    }

    public PatchFile(String parent, String child) {
        super(parent, child);
    }

    public PatchFile(File parent, String child) {
        super(parent, child);
    }

    private boolean isPathSafe() {
        boolean isSafe = false;
        String path = this.getPath();
        for (int i = 0; i < SAFE_TREES.length; ++i) {
            String testName;
            int testLength = SAFE_TREES[i].length();
            if (testLength > path.length() || !(testName = path.substring(0, testLength)).equals(SAFE_TREES[i])) continue;
            isSafe = true;
            break;
        }
        Trace.trace(TRACE_MASKT, "<> PatchFile.isPathSafe(" + path + ") - " + isSafe);
        return isSafe;
    }

    public boolean delete() {
        if (this.doViaJava) {
            return super.delete();
        }
        String args = "-target=" + this.getPath();
        return 0 == this.doPatchUtil(3, args);
    }

    public boolean exists() {
        if (this.doViaJava) {
            return super.exists();
        }
        String args = "-target=" + this.getPath();
        return 0 == this.doPatchUtil(1, args);
    }

    public boolean mkdirs() {
        boolean success = false;
        if (this.doViaJava) {
            success = super.mkdirs();
            if (!success) {
                success = super.exists();
            }
        } else {
            String args = "-target=" + this.getPath();
            int rc = this.doPatchUtil(2, args);
            if (0 == rc || 1 == rc) {
                success = true;
            }
        }
        return success;
    }

    public boolean isDirectory() {
        boolean success = false;
        if (this.doViaJava) {
            success = super.isDirectory();
        } else {
            String args = "-target=" + this.getPath();
            int rc = this.doPatchUtil(4, args);
            if (0 == rc) {
                success = true;
            }
        }
        return success;
    }

    private int doPatchUtil(int cmd, String args) {
        Trace.trace(TRACE_MASKT, "-> PatchFile.doPatchUtil() - cmd = " + cmd + ", args = [" + args + "]");
        int rc = 999;
        RootProcess theScript = new RootProcess();
        String theCommand = "actmUtil.pl -command=" + cmd + " " + args;
        try {
            rc = RootProcess.executeProgram(theCommand);
        }
        catch (IOException ioe) {
            Trace.trace(TRACE_MASKF, "   PatchFile.doPatchUtil() - exception throw by RootProcess.executeProgram(): " + ioe.getMessage());
        }
        Trace.trace(TRACE_MASKT, "<- PatchFile.doPatchUtil() - rc = " + rc);
        return rc;
    }
}

